<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\MpesaLogs;
use MPESA;
use Illuminate\Support\Facades\Log;
use Knox\AFT\AFT;
use Illuminate\Support\Facades\DB;
use App\Models\Discount;
use App\Models\Credit;
use App\Models\Sambaza;
use App\Models\Blacklist;
use App\Models\FailedAirtimeAttempts;

class MpesaController extends Controller
{
    public function initiateSTK(Request $request){
        $request->validate([
            'phone' => 'required',
            'amount' => 'required',
        ]);

        try {
            $phone_captured=str_replace(' ', '', $request->phone);
            if(strlen($phone_captured)==10){
                $phone=str_replace(' ','','254'.substr($phone_captured,1));
            }else{
                $phone=str_replace(' ','','254'.substr($phone_captured,3));
            }
            if($request->buy_for=='self'){
                $request['account']=$phone;
            }else{
                $request['account']='254'.substr($request->account,1);
            }
            $request['phone']=$phone;
            if(strlen($request->phone)!=12 || $request->amount<9){
                return ['status'=>false,'message'=>'Invalid amount or phone number.'];
            }
        $count=Blacklist::where('phone',$request->phone)->orWhere('phone',$request->account)->count();
        if($count>=1){

        return ['status'=>false,'message'=>'Your request cannot be completed,please try again later.'];
        }

            $airtime=Discount::where('name','airtime')->first();
            $less_percentage=100-$airtime->rate;//this gives 80%
            $credit=round((100*$request->amount)/$less_percentage);
            $request['credit']=$credit;

            $count=Sambaza::where('balance','>',$request->credit)->where('actual_balance','>',$request->credit)->where('status',true)->count();
            $sambaza=Sambaza::where('balance','>',$request->credit)->where('actual_balance','>',$request->credit)->where('status',true)->first();
            if($count<=0 || empty($sambaza) || $sambaza==null){
                $limited=Sambaza::where('status',true)->where('actual_balance','>',10)->where('balance','>',10)->orderBy('actual_balance','desc')->first();
             if(!empty($limited)){
                return ['status'=>false,'message'=>'Our Float is lower than your purchase. Please try lower amount.'];
             }
             return ['status'=>false,'message'=>'Dear customer, our cheap airtime float is currently low. Please try again later.','msisdn'=>$phone];
            }
            if($sambaza->locked==true){
                return ['status'=>false,'message'=>'Another transaction in progress, please try after few seconds','progress'=>true];
             }
            $mpesa = MPESA::stkPush((int)$phone,(int)$request->amount,$request->account);
            $locking=Sambaza::where('number',$sambaza->number)->update(['locked'=>true,'msisdn'=>$phone]);

            $request['system_ref']='SK'.mt_rand(10000,99999);
            $request['MerchantRequestID']=$mpesa->MerchantRequestID;
            $request['CheckoutRequestID']=$mpesa->CheckoutRequestID;
            $request['amount']=$request->amount;
            $request['phone']=$phone;
            $request['ResponseCode']=$mpesa->ResponseCode;
            $request['ResponseDescription']=$mpesa->ResponseDescription;
            $data=MpesaLogs::create($request->all());

            return ['status'=>true,'message'=>'STK pushed initiated, please enter PIN','id'=>$data->id];

        } catch (\Exception $e) {
            return ['status'=>false,'message'=>'Unable to start processing','ResponseMessage'=>$e->getMessage()];
        }
    }
    public  function checkSTKStatus(Request $request){
        $info=MpesaLogs::find($request->id);
        if($info->status=='CONFIRMED'){
            return ['status'=>true,'mpesa_ref'=>$info->mpesa_ref,'callback'=>true,'id'=>$info->id,'msisdn'=>$info->phone];
        }else if($info->status=='CANCELLED'){
            return ['status'=>true,'message'=>'User cancelled payment.Please wait.....','callback'=>false];
        }
        else{
            return ['status'=>false];
        }
    }
    public  function c2bConfirm(Request $request){
        try {
        Log::info('Calling back C2B->>>>>>>>>>>>>>>>>>>--------------->>>>>>');
        $response = json_decode($request->getContent(), true);
        Log::info($response);
        $request['mpesa_ref']=$response['TransID'];
    $request['system_ref']='SPK'.mt_rand(10000,99999);
    $request['MerchantRequestID']="NA";
    $request['CheckoutRequestID']="NA";
    $request['amount']=round($response['TransAmount']);
    $airtime=Discount::where('name','airtime')->first();

    $less_percentage=100-$airtime->rate;//this gives 80%

    $credit=round((100*$request->amount)/$less_percentage);
    $request['credit']=$credit;
    $request['ResponseCode']='NA';
    $request['ResponseDescription']='NA';
    $request['phone']=$response['MSISDN'];
    $request['TransactionType']=$response['TransactionType'];
    $request['FirstName']=$response['FirstName'];
    $request['OrgAccountBalance']=$response['OrgAccountBalance'];
    $request['status']='CONFIRMED';
    //checkIf Mpesa ID already Exist

    sleep(10);
    $count=MpesaLogs::where('mpesa_ref',$response['TransID'])->count();
    if($count<=0){
    $account=trim($response['BillRefNumber']);
    if(strlen($account)==10){
        $request['account']=str_replace(' ','','254'.substr($account,1));
    }else{
        $request['account']=str_replace(' ','','254'.substr($account,3));
    }
    $request['telco']='SAFARICOM';
    $request['disbursed']='Y';
    $count=Blacklist::where('phone',$request->phone)->orWhere('phone',$request->account)->count();
        if($count>=1){
        return ['status'=>false,'message'=>'Your request cannot be completed,please try again later.'];
        }
    $logs=MpesaLogs::create($request->all());
    $message=$logs['account'].' '.$logs['credit'];

    // $sending_no=Discount::where('name','sending_no')->first();
    $sambaza=Sambaza::where('balance','>=',$logs['credit'])->where('actual_balance','>=',$logs['credit'])->where('status',true)->orderBy('balance','desc')->first();
    if(!empty($sambaza) && $sambaza!=null){
    $sending_no=$sambaza->number;
    $balance=($sambaza->balance)-$logs['credit'];
    $actual_balance=($sambaza->actual_balance)-$logs['credit'];
    $sambaza_update=Sambaza::where('number',$sending_no)->update(['balance'=>$balance,'actual_balance'=>$actual_balance]);
    AFT::sendMessage($sending_no, $message,'BIMONDI');
    }else{
        $message3='An airtime transfer for '.$logs['account'].'  sent directly via Paybill has failed due to insufficient balance or inactive numbers among all your sambaza lines.Amount '.$logs['credit'];
        $data=AFT::sendMessage('0720714704,0712083128', $message3,'BIMONDI');
    }


    }


   } catch (\Exception $e) {
    Log::info($e->getMessage());
    $request['message']=$e->getMessage();
   }
    }

    public  function callBack(Request $request){
        try {
            Log::info('Calling back STK->>>>>>>>>>>>>>>>>>>--------------->>>>>>');
            $response = $request->all();
            Log::info($response['Body']['stkCallback']);
            $request['ResultCode'] = $response['Body']['stkCallback']['ResultCode'];
            $request['ResultDesc'] = $response['Body']['stkCallback']['ResultDesc'];
            $request['MerchantRequestID'] = $response['Body']['stkCallback']['MerchantRequestID'];
            $request['CheckoutRequestID'] = $response['Body']['stkCallback']['CheckoutRequestID'];
            if ($request->ResultCode == '0') {
                $collection = collect($response['Body']['stkCallback']['CallbackMetadata']['Item']);
                $transaction = $collection->where('Name', 'MpesaReceiptNumber')->first();
                $info=MpesaLogs::where('MerchantRequestID',$request->MerchantRequestID)->where('CheckoutRequestID',$request->CheckoutRequestID)->where('status','PENDING')->first();
                $logs=MpesaLogs::find($info->id);
                $request['status']='CONFIRMED';
                $request['mpesa_ref']=$transaction['Value'];
                $request['trans_id']=$transaction['Value'];
                $request['payment_ref']=$transaction['Value'];
                $request['system_id']=$logs->system_ref;
                $request['payment_method']='M-PESA EXPRESS';
                $request['payment_id']=$transaction['Value'];
                $request['disbursed']='Y';
                $count=MpesaLogs::where('mpesa_ref',$transaction['Value'])->count();
                if($count<=0){
                $logs->update($request->all());

                 if(strlen($logs['phone'])==10){
                     $phone=$logs['phone'];
                 }else{
                     $phone=str_replace(' ','','0'.substr($logs['phone'],3));
                 }
                 $message=$logs['account'].' '.$logs['credit'];
                //  $sending_no=Discount::where('name','sending_no')->first();
                $sambaza=Sambaza::where('msisdn',$logs['phone'])->first();
                if(!empty($sambaza) && $sambaza!=null){
                 $sending_no=$sambaza->number;
                 $balance=($sambaza->balance)-$logs['credit'];
                 $actual_balance=($sambaza->actual_balance)-$logs['credit'];
                 $sambaza_update=Sambaza::where('number',$sending_no)->update(['balance'=>$balance,'actual_balance'=>$actual_balance,'locked'=>false,'msisdn'=>'NA']);
                 AFT::sendMessage($sending_no, $message,'BIMONDI');
                 }else{
                    $message3='An airtime transfer for '.$logs['phone'].' sent via stk has failed due to insufficient balance or inactive numbers among all your sambaza lines.Amount '.$logs['credit'];
                    $data=AFT::sendMessage('0720714704,0712083128', $message3,'BIMONDI');
                 }


                //  if($logs->buy_for=='other'){
                //     $request['type']='BONUS';
                //     $request['phone']=$logs->phone;
                //     $request['system_ref']=$logs->system_ref;
                //     $request['value']=$logs['credit'];
                //     $request['amount']=($request->value*15)/100;
                //     $request['status']='PENDING';
                //     $credit=Credit::create($request->all());
                //  }
            }

            }else{
                $info=MpesaLogs::where('MerchantRequestID',$request->MerchantRequestID)->where('CheckoutRequestID',$request->CheckoutRequestID)->first();
                $logs=MpesaLogs::find($info->id);
                $request['status']='CANCELLED';
                $logs->update($request->all());
                $sambaza_update=Sambaza::where('msisdn',$logs['phone'])->update(['locked'=>false,'msisdn'=>'NA']);

            }

        } catch (\Exception $e) {
            Log::info($e->getMessage());
            $request['message']=$e->getMessage();
        }
    }
    public function registerURL(Request $request){
        $mpesa = MPESA::registerC2bUrl();
        Log::info(json_encode($mpesa));
        return ['mpesa'=>$mpesa];
    }
    public function getTransactionStatus(Request $request){
        try{
        Log::info($request->all());
        $code=trim(strtok($request->code, " "));
        $str = substr($request->code, strpos($request->code, 'account')+ 7);
        $acc=trim(strtok($str, " "));
        if(strlen($acc)==10){
            $account=str_replace(' ','','254'.substr($acc,1));
        }else{
            $account=str_replace(' ','','254'.substr($acc,3));
        }
        Log::info($code);
        Log::info($account);
        $checkCode=MpesaLogs::where('mpesa_ref',$code)->where('status','CONFIRMED')->count();
        if($checkCode>=1){
            return ['status'=>false,'message'=>'Sorry, the code '.$code.' has already been used.Please contact support for further assistance.'];
        }
        if(strlen($account)!=12){
            return ['status'=>false,'message'=>'The message has invalid information.Please contact support'];
        }
        $mpesa = MPESA::getTransactionStatus($code, null,4);
        Log::info(json_encode($mpesa));
        $request['system_ref']='SK'.mt_rand(10000,99999);
        $request['MerchantRequestID']=$mpesa->OriginatorConversationID;
        $request['CheckoutRequestID']=$mpesa->ConversationID;
        $request['amount']='0';
        $request['credit']='0';
        $request['phone']=$account;
        $request['mpesa_ref']=$code;
        $request['account']=$account;
        $request['ResponseCode']=$mpesa->ResponseCode;
        $request['ResponseDescription']=$mpesa->ResponseDescription;
        $data=MpesaLogs::create($request->all());

        return ['status'=>true,'message'=>'Request Sent successfully,please wait for confirmation message.'];


    } catch (\Exception $e) {
        Log::info($e->getMessage());
        return ['status'=>false,'message'=>$e->getMessage()];
    }
    }

    public function statusCallBackUrl(Request $request){
        try {
        Log::info('Calling back statusCallback->>>>>>>>>>>>>>>>>>>--------------->>>>>>');
        $response = $request->all();
        Log::info(json_encode($response));
        $request['ResultCode'] = $response['Result']['ResultCode'];
        $request['ResultDesc'] = $response['Result']['ResultDesc'];
        if ($request->ResultCode == '0') {
            $collection = collect($response['Result']['ResultParameters']['ResultParameter']);
            $merchantRequestId=$response['Result']['OriginatorConversationID'];
            $checkoutRequestId=$response['Result']['ConversationID'];

            $transaction = $collection->where('Key', 'ReceiptNo')->first();
            $record=MpesaLogs::where('MerchantRequestID',$merchantRequestId)->where('CheckoutRequestID',$checkoutRequestId)->where('status','PENDING')->where('mpesa_ref',$transaction['Value'])->first();
            if(!empty($record)){
                $logs=MpesaLogs::find($record->id);
                $request['status']='CONFIRMED';
                $request['mpesa_ref']=$transaction['Value'];
                $request['trans_id']=$transaction['Value'];
                $request['payment_ref']=$transaction['Value'];
                $request['system_id']=$logs->system_ref;
                $request['payment_method']='M-PESA CONFIRMATION';
                $request['payment_id']=$transaction['Value'];
                $request['disbursed']='Y';
                $phoneData=$collection->where('Key', 'DebitPartyName')->first();
                $phone=trim(strtok($phoneData['Value'], " "));
                $request['phone']=$phone;
                $amountData=$collection->where('Key', 'Amount')->first();
                $amount=$amountData['Value'];

                $request['amount']=round($amount);
                $airtime=Discount::where('name','airtime')->first();
                $less_percentage=100-$airtime->rate;//this gives 80%

                $credit=round((100*$request->amount)/$less_percentage);
                $request['credit']=$credit;
                $logs->update($request->all());

                 if(strlen($logs['phone'])==10){
                     $phone=$logs['phone'];
                 }else{
                     $phone=str_replace(' ','','0'.substr($logs['phone'],3));
                 }

                $account=$logs['account'];
                 $message=$logs['account'].' '.$logs['credit'];

                //  $sending_no=Discount::where('name','sending_no')->first();
                $sambaza=Sambaza::where('balance','>=',$logs['credit'])->where('actual_balance','>=',$logs['credit'])->where('status',true)->orderBy('balance','asc')->first();
                 if(!empty($sambaza) && $sambaza!=null){
                 $sending_no=$sambaza->number;
                 $balance=($sambaza->balance)-$logs['credit'];
                 $actual_balance=($sambaza->actual_balance)-$logs['credit'];
                 $sambaza_update=Sambaza::where('number',$sending_no)->update(['balance'=>$balance,'actual_balance'=>$actual_balance]);
                 AFT::sendMessage($sending_no, $message,'BIMONDI');
                 }else{
                    $message3='An airtime transfer for '.$logs['account'].' has failed due to insufficient balance in all your sambaza lines.Amount '.$logs['credit'];
                    $data=AFT::sendMessage('0720714704,0712083128', $message3,'BIMONDI');
                 }

            }
        }

    } catch (\Exception $e) {
        Log::info($e->getMessage());
        $request['message']=$e->getMessage();
    }
    }



}
